<?php

// to show all errors
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// To hide all errors
// error_reporting(0);
// ini_set('display_errors', 0);


include_once "../db_connection.php";
// require_once 'resend_functions1.php';

// Function to resend PAN and log resends
function resendPAN($conn, $PAN_ID, $FormType, $secretkey, $opts = []) {
    date_default_timezone_set('America/Chicago'); // Chicago timezone
  //   $db_connection = include '../db_connection.php';
  // $secretkey = $db_connection['secretkey']; // string


    $opts = array_merge([
        'config_path' => __DIR__ . '/../config.php',
        'log_file'    => __DIR__ . '/resend_log.txt'
    ], $opts);

    $PAN_ID = intval($PAN_ID);
    if ($PAN_ID <= 0) {
        return ['success' => false, 'error' => 'Invalid PAN_ID'];
    }

    // Load PAN record
    $sql = "SELECT * FROM PAN_newhires WHERE PAN_ID = ? LIMIT 1";
    $stmt = $conn->prepare($sql);
    if (!$stmt) return ['success'=>false,'error'=>'Prepare failed: '.$conn->error];

    $stmt->bind_param('i', $PAN_ID);
    $stmt->execute();
    $data = $stmt->get_result()->fetch_assoc();
    $stmt->close();

    if (!$data) return ['success'=>false,'error'=>'No record found for PAN_ID '.$PAN_ID];

    // Load email config
$emailConfig = file_exists($opts['config_path']) ? include $opts['config_path'] : [];
$branch = strtoupper(trim($data['branch'] ?? ''));
$department = strtoupper(trim($data['department'] ?? ''));
$normalizedConfig = [];

// Normalize branch/department emails
foreach ($emailConfig as $b => $deps) {
    if ($b === 'default') {
        $normalizedConfig['default'] = $deps; // keep default untouched
        continue;
    }

    if (!is_array($deps)) continue;
    $bKey = strtoupper(trim($b));
    foreach ($deps as $d => $email) {
        $normalizedConfig[$bKey][strtoupper(trim($d))] = $email;
    }
}

// Use branch/department email, fallback to default
$to = !empty($normalizedConfig[$branch][$department])
      ? $normalizedConfig[$branch][$department]
      : ($normalizedConfig['default'] ?? null);


    $subject = "PERSONNEL ACTION NOTICE - " . strtoupper(($data['first_name'] ?? '') . ' ' . ($data['last_name'] ?? ''));

    // After resolving $to from $normalizedConfig
    $recipientName = '';

    // Attempt to get name from email address
    if (!empty($to)) {
        // Example: "tester.test@email.com" => "Tester Test"
        $emailUser = explode('@', $to)[0]; // "tester.test"
        $emailUserParts = preg_split('/[._]/', $emailUser); // ["tester", "test"]
        $emailUserParts = array_map('ucfirst', $emailUserParts); // ["Tester","Test"]
        $recipientName = implode(' ', $emailUserParts); // "Tester Test"
    }

    // Default if somehow parsing fails
    if (empty($recipientName)) {
        $recipientName = 'Approver';
    }

    // Prepare section arrays
    $personnelNoticeList = [
        'PAN_ID'           => $data['PAN_ID'],
        'first_name'       => $data['first_name'],
        'last_name'        => $data['last_name'],
        'effective_date'   => $data['effective_date'],
        'branch'           => $data['branch'],
        'department'       => $data['department'],
        'employeeID'       => $data['employeeID'],
        'address'          => $data['address'],
        'city'             => $data['city'],
        'state'            => $data['state'],
        'zip'              => $data['zip'],
        'telephone'        => $data['telephone']
    ];


    $newhireList = [
        'Hire_Reason'           => $data['Hire_Reason'],
        'replacement_for'       => $data['replacement_for'],
        'employment_Status'     => $data['employment_Status'],
        'drivers_License'       => decryptthis($data['drivers_License'], $secretkey),
        'state_Issued'          => $data['state_Issued'],
        'date_of_Birth'         => decryptthis($data['date_of_Birth'], $secretkey),
        'gender'                => $data['gender'],
        'ethnic_Code'           => $data['ethnic_Code'],
        'marital_Status'        => $data['marital_Status'],
        'job_Title'             => $data['job_Title'],
        'starting_Rate'         => decryptthis($data['starting_Rate'], $secretkey),
        'per'                   => $data['per'],
        'bonus_Commission_Plan' => $data['bonus_Commission_Plan'],
        'bonus_Level'           => $data['bonus_Level'],
        'Training_Needed'       => $data['Training_Needed'],
        'Technician_shift' => $data['Technician_shift'] ?? '',
        'Alarm_Code'            => $data['Alarm_Code'],
        'Need_Workstation'      => $data['Need_Workstation'],
        'New_Hire_Remarks'      => $data['New_Hire_Remarks']
    ];

    $changeList = [
        'Job_Title_From'        => $data['Job_Title_From'],
        'Job_Title_To'          => $data['Job_Title_To'],
        'Pay_From'              => decryptthis($data['Pay_From'], $secretkey),
        'Pay_From_Per'          => $data['Pay_From_Per'],
        'Pay_To'                => decryptthis($data['Pay_To'], $secretkey),
        'Pay_To_Per'            => $data['Pay_To_Per'],
        'From_Branch'           => $data['From_Branch'],
        'To_Branch'             => $data['To_Branch'],
        'From_Department'       => $data['From_Department'],
        'To_Department'         => $data['To_Department'],
        'From_Employee_Status'  => $data['From_Employee_Status'],
        'To_Employee_Status'    => $data['To_Employee_Status'],
        'Change_Remarks'        => $data['Change_Remarks']
    ];

    $separationList = [
        'Hire_Date'                     => $data['Hire_Date'],
        'Last_Day_Worked'               => $data['Last_Day_Worked'],
        'Separation_Date'               => $data['Separation_Date'],
        'Separation_Type'               => $data['Separation_Type'],
        'Separation_Reason'             => $data['Separation_Reason'],
        'Eligible_to_Rehire'            => $data['Eligible_to_Rehire'],
        'forward_emails'                => $data['forward_emails'],
        'forwarding_to_employee_name'   => $data['forwarding_to_employee_name'],
        'Separation_Remarks'            => $data['Separation_Remarks']
    ];

    // Build HTML email template (same as resendEmail.php)
    $c = 0;
    $email_message = '<html><body>';
    $email_message .= '<p>Hello ' . htmlspecialchars($recipientName) . ',</p>';
    $email_message .= '<p>It has been over 24 hours since below PAN was submitted for your approval.  Please Approve or Reject at your earliest convenience.</p>';
    // $email_message .= '<p>Here are the details of the PAN:</p>';

    $email_message .= '<table rules="all" style="border-color: #666; font-family: Montserrat-Regular; font-size:14px; border-radius:7px 7px 0 0" cellpadding="10">';
    $email_message .= '<tr style="background: #fff"><td colspan="2" align="center"><img src="http://www.selectransportation.com/helpdesk/Images/STR-LOGO1.png"></td></tr>';
    $email_message .= '<tr style="background: #000000; color:#fff; border-radius: 8px 8px 0 0"><td colspan="2" align="center"><h3>' . strip_tags($subject) .'</h3></td></tr>';


    foreach ($personnelNoticeList as $key => $personnelNoticeListValues) {

                if(isset($data[$key]) && $data[$key] != ''){

                    // Adds alternate colors to the table rows
                    $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
                    // $colorOne = '#ffffff';
                    // $colorTwo = '#f3f3f3';
                    // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
                    // $rowCount++;

                    // email Body
                    $email_message .= '<tr bgcolor="' . $colour . '">';
                    $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
                     // $email_message .= '<td>'. wordwrap(htmlspecialchars($row[$key], ENT_QUOTES),75, "<br />\n") .'</td>';
                    // $email_message .= '<td>'. wordwrap(htmlspecialchars((decryptthis($row[$key], $secretkey)), ENT_QUOTES),75, "<br />\n") .'</td>';
                    $email_message .= '<td>'. wordwrap(htmlspecialchars($personnelNoticeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
                    $email_message .= '</tr>';
                    $c++;

                  }
               }




    // foreach ([$personnelNoticeList, $newhireList, $changeList, $separationList] as $section) {
    //     foreach ($section as $key => $value) {
    //         if (!empty($value)) {
    //             $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
    //             $email_message .= '<tr bgcolor="' . $colour . '">';
    //             $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
    //             $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($value, ENT_QUOTES),75, "<br />\n") .'</td>';
    //             $email_message .= '</tr>';
    //             $c++;
    //         }
    //     }
    // }


    $email_message .= '<tr style="background: #000000; color:#fff;"><td colspan="2" align="center" id="NewHireEmailTitle"><h3>'. $data['FormType'] . '</h3></td></tr>';
    foreach ($newhireList as $key => $newhireListValues) {
          if(isset($data[$key]) && $data[$key] != ''){

            // Adds alternate colors to the table rows
            $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
            // $colorOne = '#ffffff';
            // $colorTwo = '#f3f3f3';
            // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
            // $rowCount++;

            // email Body
            $email_message .= '<tr bgcolor="' . $colour . '">';
            $email_message .= '<td><strong>'. ucwords(str_replace("_", " ", $key))  . '</strong></td>';
            $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($newhireListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
            $email_message .= '</tr>';
            $c++;
          }
       }

   // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="ChangeEmailTitle"><h3>'. $ChangeEmailTitle . '</h3></td></tr>';
   foreach ($changeList as $key => $changeListValues) {
             if(isset($data[$key]) && $data[$key] != ''){

               // echo "$key: $changeListValues\n <br />";

               // Adds alternate colors to the table rows
               $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
               // $colorOne = '#ffffff';
               // $colorTwo = '#f3f3f3';
               // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
               // $rowCount++;

               // email Body
               $email_message .= '<tr bgcolor="' . $colour . '">';
               $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
               $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($changeListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
               $email_message .= '</tr>';
               $c++;
          }
      }

  // $email_message .= '<tr style="background: #000000; color:#fff; display:block"><td colspan="2" align="center" id="SeparationEmailTitle"><h3>'. $SeparationEmailTitle . '</h3></td></tr>';
  foreach ($separationList as $key => $separationListValues) {
          if(isset($data[$key]) && $data[$key] != ''){

              // Adds alternate colors to the table rows
              $colour = ($c % 2 == 0) ? '#ffffff' : '#f3f3f3';
              // $colorOne = '#ffffff';
              // $colorTwo = '#f3f3f3';
              // $rowColor = ($rowCount % 2) ? $colorOne : $colorTwo;
              // $rowCount++;

              // email Body
              $email_message .= '<tr bgcolor="' . $colour . '">';
              $email_message .= '<td><strong>'. ucwords(str_replace("_", " ",$key))  . '</strong></td>';
              $email_message .= '<td style="text-align:justify; text-justify: distribute; text-align-last: left;">'. wordwrap(htmlspecialchars($separationListValues, ENT_QUOTES),75, "<br />\n") .'</td>';
              $email_message .= '</tr>';
              $c++;
          }
      }


    // Attachment row
    $email_message .= '<tr>';
    if (empty($data['Attachment'])) {
        $email_message .= '<td style="display: none;"><h5>NO ATTACHMENTS</h5></td>';
    } else {
        $email_message .= '<td colspan="2" width="100%" height="30" style="background-color: #0047AB; text-align:center; color: #ffffff;">';
        $email_message .= '<a href="https://helpdesk.selectransportation.com/uploads/'. $data['Attachment'] . '" style="font-size:15px; font-weight: bold; font-family: Helvetica, Arial, sans-serif; text-decoration: none; line-height:40px; width:100%; display:inline-block"><span style="color: #FFFFFF">ATTACHMENT</span></a>';
        $email_message .= '</td>';
    }
    $email_message .= '</tr>';

    // Approve/Reject button
    $email_message .= '<tr bgcolor="#ccc">';
    $email_message .= '<td colspan="2" width="100%" height="30" bgcolor="#1F7F4C" style="text-align:center; color: #ffffff;">';
    $email_message .= '<a href="https://helpdesk.selectransportation.com/approval.php?PAN_ID=' . base64_encode($PAN_ID) .  '&personnelOnly=' . base64_encode($FormType) .'" style="font-size:15px; font-weight: bold; font-family: Helvetica, Arial, sans-serif; text-decoration: none; line-height:40px; width:100%; display:inline-block"><span style="color: #FFFFFF">APPROVE/REJECT</span></a>';
    $email_message .= '</td></tr>';

    $email_message .= "<tr style='background: #000000; color:#fff; border-radius: 8px 8px 0 0'><td colspan='2' align='center'>Copyright &copy STR HelpDesk. All Rights Reserved.</td></tr>";
    $email_message .= "</table></body></html>";

    $fromName = !empty($data['fromName']) ? $data['fromName'] : 'STR HelpDesk';
    $fromEmail = !empty($data['from_email']) ? $data['from_email'] : 'no-reply@selectransportation.com';

    $headers = "From: $fromName <$fromEmail>\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";

    $mailOk = @mail($to, $subject, $email_message, $headers);

    // Logging
    $logLine = date('Y-m-d H:i:s') . " | PAN_ID: $PAN_ID | To: $to | FormType: $FormType | Success: " . ($mailOk ? 'Yes' : 'No') . "\n";
    file_put_contents($opts['log_file'], $logLine, FILE_APPEND);

    return $mailOk ? ['success'=>true, 'to'=>$to, 'subject'=>$subject] : ['success'=>false, 'error'=>'mail() failed', 'to'=>$to, 'subject'=>$subject];
}
