<?php
session_start();

// to show all errors
// error_reporting(E_ALL);
// ini_set('display_errors', '1');

// To hide all errors
error_reporting(0);
ini_set('display_errors', 0);


// Function to authenticate users based on hardcoded usernames
function authenticateUser($username) {
    // List of hardcoded usernames
        $hardcodedUsernames = array("100494", "101496", "102224", "101349", "101717", "100106", "100357");
        //Jared Bonasera , Melissa Deases, Daniel Cortes, Sameer Patwa, Saquib, Chip Stewart,  Bill Simko

    // Check if the submitted username is in the list of hardcoded usernames
    return in_array($username, $hardcodedUsernames);
}

// Check if form is submitted
if(isset($_POST['hardcodedUser']) && isset($_POST['phxPass'])) {
    // Retrieve submitted username and password
    $username = $_POST['hardcodedUser'];
    $password = $_POST['phxPass'];

    // Authenticate user based on hardcoded usernames
    if(authenticateUser($username)) {
        // Connect to the API for password validation
        $wp_request_url = 'https://php.selecsoftwarellc.com/api/Authentication/ValidateCredentials_Employee_WithFullName';
        $wp_Get_post_response = stream_context_create(array(
            'http' => array(
                'header' => "Authorization: Basic " . base64_encode($username . ":" . $password),
            ),
        ));
        $loginInfo = @file_get_contents($wp_request_url, false, $wp_Get_post_response);
        $loginInfo = json_decode($loginInfo, true);

        // Process the API response
        if(isset($loginInfo) && $loginInfo['Status']==1)
        {

          $_SESSION["userid"] = $_POST["hardcodedUser"];
          $_SESSION["hardcodedUser"] = $loginInfo['FullName'];
          $_SESSION['loggedin_Activity'] = time();


          // Redirect to PANtrackDashboard.php on successful login
            header("Location: PANtrackDashboard.php");
            // echo '<script type="text/javascript"> location.replace("/hdesk/helpdesk/PANtrackDashboard.php","_self");</script>';
            exit(); // Stop further execution

      } else {
        // Invalid credentials
        $error = "<i class='fa fa-exclamation-triangle' style='color:red' aria-hidden='true'></i> Invalid credentials.";
         $_SESSION["error_message"] = $error; // Set error message in session
      }

    } else {
        // Username is not in the list of hardcoded usernames
        $error = "<i class='fa fa-times-circle' style='color:red' aria-hidden='true'></i> You are not authorized to use this resource, contact HR.";
        $_SESSION["error_message"] = $error; // Set error message in session
    }
}


// If there's a login error, it will be displayed
if(isset($_SESSION["error_message"])) {
    $error = $_SESSION["error_message"];
    unset($_SESSION["error_message"]); // Clear the error message from session after displaying
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PAN TRACKING</title>

    <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="57x57" href="../helpdesk/Images/icons/Icons/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="../helpdesk/Images/icons/Icons/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="../helpdesk/Images/icons/Icons/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="../helpdesk/Images/icons/Icons/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="../helpdesk/Images/icons/Icons/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="../helpdesk/Images/icons/Icons/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="../helpdesk/Images/icons/Icons/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="../helpdesk/Images/icons/Icons/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="../helpdesk/Images/icons/Icons/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192"  href="../helpdesk/Images/icons/Icons/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="../helpdesk/Images/icons/Icons/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="../helpdesk/Images/icons/Icons/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="../helpdesk/Images/icons/Icons/favicon-16x16.png">
    <link rel="mask-icon" href="../helpdesk/Images/icons/Icons/safari-pinned-tab.svg" color="#5bbad5">
    <link rel="manifest" href="../helpdesk/Images/icons/Icons/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="../helpdesk/Images/icons/Icons/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">


    <!-- BOOTSTRAP 4 CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

    <!-- CUSTOM STYLES -->
    <link rel="stylesheet" href="/hdesk/helpdesk/css/PANtrackingStyles.css">

    <!-- FONT AWESOME -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <!-- <link rel="stylesheet" href="../../../helpdesk/css/ModifyDatastyles.css"></link> -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function() {
            // Check if there is an error message, then fade it out
            <?php if(isset($error)): ?>
                $("#error-message").fadeIn().delay(8000).fadeOut();
            <?php endif; ?>
        });
    </script>
</head>
<body>
  <div class="container mt-5" >
      <div class="row justify-content-center">
          <div class="col-md-6">
              <div class="card">
                  <div class="card-header" align="center">
                        <div align="center" class="col-md-12" ><img src="/hdesk/helpdesk/Images/Logo-Main.png" alt="logo"></div>
                      <h4 class="cardTitle shadows mt-2">PAN TRACKING LOGIN</h4>
                  </div>
                  <div class="card-body">
                      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]);?>" method="POST">
                          <div class="form-group">
                              <label for="user">Username</label>
                              <input type="text" class="form-control" id="hardcodedUser" name="hardcodedUser" required>
                          </div>
                          <div class="form-group">
                              <label for="pass">Password</label>
                              <input type="password" class="form-control" id="phxPass" name="phxPass" required>
                          </div>


                          <!-- <?php if (isset($error)): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo $error; ?>
                                </div>
                            <?php endif; ?> -->

                            <div id="error-message" class="alert alert-danger" role="alert" style="display:none">
                                <?php
                                    if(isset($error)) {
                                        echo $error;
                                    }
                                ?>
                            </div>

                          <button type="submit" class="btn font-weight-bold btncolor">LOGIN</button>
                      </form>
                  </div>
              </div>
          </div>
      </div>
  </div>

</body>
</html>
