<?php
//For enabling and disabling the helpdesk page
include 'ToggleHelpdeskConfig.php';

// Handle the toggle request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $HelpdeskEnabled = !$HelpdeskEnabled;
    file_put_contents('ToggleHelpdeskConfig.php', "<?php\n\$HelpdeskEnabled = " . ($HelpdeskEnabled ? 'true' : 'false') . ";\n?>");
    echo json_encode(['status' => $HelpdeskEnabled]);
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=Edge,chrome=1" />
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta http-equiv="cache-control" content="no-cache">
     <title>Toggle STR Help Desk</title>

     <!--===============================================================================================-->
      <!-- This is to create an App Icon when you save to you website to your homescreen.
           Use the website www.favicon-generator.org/ to create an app icon and the code from the same website -->

          <link rel="apple-touch-icon" sizes="57x57" href="../Images/icons/Icons/apple-icon-57x57.png">
          <link rel="apple-touch-icon" sizes="60x60" href="../Images/icons/Icons/apple-icon-60x60.png">
          <link rel="apple-touch-icon" sizes="72x72" href="../Images/icons/Icons/apple-icon-72x72.png">
          <link rel="apple-touch-icon" sizes="76x76" href="../Images/icons/Icons/apple-icon-76x76.png">
          <link rel="apple-touch-icon" sizes="114x114" href="../Images/icons/Icons/apple-icon-114x114.png">
          <link rel="apple-touch-icon" sizes="120x120" href="../Images/icons/Icons/apple-icon-120x120.png">
          <link rel="apple-touch-icon" sizes="144x144" href="../Images/icons/Icons/apple-icon-144x144.png">
          <link rel="apple-touch-icon" sizes="152x152" href="../Images/icons/Icons/apple-icon-152x152.png">
          <link rel="apple-touch-icon" sizes="180x180" href="../Images/icons/Icons/apple-icon-180x180.png">
          <link rel="icon" type="image/png" sizes="192x192"  href="../Images/icons/Icons/android-icon-192x192.png">
          <link rel="icon" type="image/png" sizes="32x32" href="../Images/icons/Icons/favicon-32x32.png">
          <link rel="icon" type="image/png" sizes="96x96" href="../Images/icons/Icons/favicon-96x96.png">
          <link rel="icon" type="image/png" sizes="16x16" href="../Images/icons/Icons/favicon-16x16.png">
          <link rel="mask-icon" href="../Images/icons/Icons/safari-pinned-tab.svg" color="#5bbad5">
          <link rel="manifest" href="../Images/icons/Icons/manifest.json">
          <meta name="msapplication-TileColor" content="#ffffff">
          <meta name="msapplication-TileImage" content="../Images/icons/Icons/ms-icon-144x144.png">
          <meta name="theme-color" content="#ffffff">

      <!--===============================================================================================-->

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>


    <style>
        /* Button styles */
        #toggleHelpdeskButton {
            padding: 12px 24px;
            border: 2px solid transparent;
            border-radius: 8px;
            font-size: 16px;
            cursor: pointer;
            color: white;
            transition: background-color 0.3s ease, box-shadow 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        /* Button style when showing 'Enable HELPDESK' */
        .enable {
            background-color: green;
        }
        /* Button style when showing 'Disable HELPDESK' */
        .disable {
            background-color: red;
        }
        /* Add hover effect for the button */
        #toggleHelpdeskButton:hover {
            box-shadow: 0 6px 10px rgba(0, 0, 0, 0.15);
        }
        /* Status text styles */
        .status-enabled span {
            color: green;
            font-weight: bold;
        }
        .status-disabled span {
            color: red;
            font-weight: bold;
        }

    </style>

</head>
<body>
    <h1>Toggle Helpdesk Status</h1>
    <button id="toggleHelpdeskButton" class="<?php echo $HelpdeskEnabled ? 'disable' : 'enable'; ?>">
        <?php echo $HelpdeskEnabled ? 'Disable HELPDESK' : 'Enable HELPDESK'; ?>
    </button>
    <p id="currentStatus" class="<?php echo $HelpdeskEnabled ? 'status-enabled' : 'status-disabled'; ?>">
        Current Status: <span><?php echo $HelpdeskEnabled ? 'Enabled' : 'Disabled'; ?></span>
    </p>

    <script>
        $(document).ready(function() {
            $('#toggleHelpdeskButton').click(function() {
                $.post('toggle_Helpdesk.php', function(data) {
                    const response = JSON.parse(data);
                    const isEnabled = response.status;

                    // Update button text and styles based on current status
                    $('#toggleHelpdeskButton')
                        .text(isEnabled ? 'Disable HELPDESK' : 'Enable HELPDESK')
                        .removeClass('enable disable')
                        .addClass(isEnabled ? 'disable' : 'enable');

                    // Update current status text and styles
                    $('#currentStatus')
                        .html('Current Status: <span>' + (isEnabled ? 'Enabled' : 'Disabled') + '</span>')
                        .removeClass('status-enabled status-disabled')
                        .addClass(isEnabled ? 'status-enabled' : 'status-disabled');
                });
            });
        });
    </script>
</body>
</html>
